<?php
include_once './vendor/autoload.php';
defined('BASEPATH') or exit('No direct script access allowed');

// these line are for tesing purpose and to allow request from local server
Header('Access-Control-Allow-Origin: http://localhost:3000'); //for allow any domain, insecure
Header('Access-Control-Allow-Headers: http://localhost:3000'); //for allow any headers, insecure
Header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE'); //method allowed
require APPPATH . 'libraries/REST_Controller.php';
require APPPATH . 'libraries/Format.php';


//Or


class Auth extends REST_Controller
{

    function __construct()
    {
        // Construct the parent class
        parent::__construct();

        $this->load->model('MyModel');
        $this->load->library('form_validation');
        $this->load->helper("security");
        $this->load->helper('string');
        $this->load->helper("file");
        $this->load->helper('url');
    }

    public function login_post()
    {
        $method = $this->input->method();

        if ($method != 'post') {
            $this->response(array('status' => false, 'message' => 'Method not POST'), REST_Controller::HTTP_BAD_REQUEST);
        } else {
            $check_auth_client = $this->MyModel->check_auth_client_login();

            if ($check_auth_client == true) {
                // Retrieve the raw JSON data from the request body
                $json_data = file_get_contents('php://input');
                $data = json_decode($json_data, true);

                if (empty($data)) {
                    $this->response(array('status' => false, 'message' => 'Invalid JSON data'), REST_Controller::HTTP_BAD_REQUEST);
                }

                $email = $data['email'];
                $password = $data['password'];

                if (empty($email) || empty($password)) {
                    $error = array(
                        'status' => false,
                        'message' => 'Email or Password field should not be empty.'
                    );
                    $this->response($error, REST_Controller::HTTP_BAD_REQUEST);
                } else {
                    // Encrypt the password
                    // $password = sha1($password);
                    $q = $this->db->select('*')->from('user')->where('email', $email)->get()->row();

                    if ($q != null) {
                        $user_id = $q->id;

                        // Update f_token in the database.
                        $data['f_token'] = "test";
                        $token_update = $this->MyModel->update_token($data, $user_id);

                        if ($token_update) {
                            $model_response = $this->MyModel->login($email, $password);
                            $this->response($model_response, REST_Controller::HTTP_OK);
                        } else {
                            $failure = array(
                                'status' => false,
                                'message' => 'f_token not updated',
                            );
                            $this->response($failure, REST_Controller::HTTP_BAD_REQUEST);
                        }
                    } else {
                        $failure = array(
                            'status' => false,
                            'message' => 'User Not Found in the database',
                        );
                        $this->response($failure, REST_Controller::HTTP_BAD_REQUEST);
                    }
                }
            } else {
                $failure = array(
                    'status' => false,
                    'message' => 'Missing Request Header'
                );
                $this->response($failure, REST_Controller::HTTP_BAD_REQUEST);
            }
        }
    }



    public function signup_post()
    {
        $method = $this->input->method();

        if ($method != 'post') {
            $this->response(array('status' => false, 'message' => 'Method not POST'), REST_Controller::HTTP_BAD_REQUEST);
        } else {
            $check_auth_client = $this->MyModel->check_auth_client_login();

            if ($check_auth_client == true) {
                // Retrieve the raw JSON data from the request body
                $json_data = file_get_contents('php://input');
                $data = json_decode($json_data, true);

                if (empty($data)) {
                    $this->response(array('status' => false, 'message' => 'Invalid JSON data'), REST_Controller::HTTP_BAD_REQUEST);
                }

                $this->form_validation->set_data($data);
                $this->form_validation->set_rules('name', 'Name', 'required');
                $this->form_validation->set_rules('email', 'Email', 'required|valid_email|is_unique[user.email]');
                $this->form_validation->set_rules('password', 'Password', 'required');
                $this->form_validation->set_rules('phone', 'Phone', 'required');
                $this->form_validation->set_rules('f_token', 'f_token', 'required');

                if ($this->form_validation->run() == false) {
                    $errors = array(
                        'name' => strip_tags(form_error('name')),
                        'email' => strip_tags(form_error('email')),
                        'password' => strip_tags(form_error('password')),
                        'phone' => strip_tags(form_error('phone')),
                        'f_token' => strip_tags(form_error('f_token'))
                    );

                    $this->response(array('status' => false, 'message' => 'Validation errors', 'data' => $errors), REST_Controller::HTTP_BAD_REQUEST);
                } else {
                    $data = array(
                        'name' => $data['name'],
                        'email' => $data['email'],
                        'password' => sha1($data['password']),
                        'phone_number' => $data['phone'],
                        'f_token' => $data['f_token']
                    );

                    $model_response = $this->MyModel->signup($data);

                    $this->response($model_response, REST_Controller::HTTP_OK);
                }
            } else {
                $failure = array(
                    'status' => false,
                    'message' => 'Missing Request Header',
                    'data' => array()
                );

                $this->response($failure, REST_Controller::HTTP_BAD_REQUEST);
            }
        }
    }
    public function sendemail_code_post()
    {
        $data = json_decode(trim(file_get_contents('php://input')), true);

        $mail_to = isset($data['email']) ? $data['email'] : '';

        // Validate email
        if (empty($mail_to) || !filter_var($mail_to, FILTER_VALIDATE_EMAIL)) {
            $failure = array(
                'status' => false,
                'message' => 'Invalid email.',
                'data' => (object) array()
            );
            $this->response($failure, REST_Controller::HTTP_BAD_REQUEST);
        }

        $uniqid = rand(1000, 9999);

        // $q = $this->db->select('*')->from('user')->where('email', $mail_to)->get()->row();
        // $name = $q->name;

        $query = $this->db->get_where('user', array('email' => $mail_to));

        if ($query->num_rows() > 0) {
            $q = $query->row();
            $name = $q->name;

            $this->load->library('email');

            $html = "halo";

            $config = array();

            $config['protocol'] = 'SMTP';
            $config['smtp_host'] = 'megaxtudio.com';
            $config['smtp_crypto'] = 'ssl';
            $config['smtp_port'] = '587';
            $config['smtp_timeout'] = '7';
            $config['smtp_user'] = 'info@megaxtudio.com';
            $config['smtp_pass'] = 'info@Pakistan123';
            $config['charset'] = 'utf-8';
            $config['newline'] = "\r\n";
            $config['mailtype'] = 'html'; // or html
            $config['validation'] = true; // bool whether to validate email or not
            $this->email->initialize($config);

            $this->email->from('info@megaxtudio.com', 'Appointment OTP.');

            $this->email->to($mail_to);
            $this->email->subject('Please input the given 4-digit code to change your password.');

            $this->load->model('MyModel');
            $code_data['f_pass_mailcode'] = $uniqid;
            $this->MyModel->update_mail_code($mail_to, $code_data);

            $message = "Dear " . $name . ",<br><br>" . "Your One-Time Password (OTP) is <b>" . $uniqid . "</b><br><br>" . "In order to protect your account from misuse/fraudulent activity, please do not share the OTP with anyone.<br><br>" . "Note: Please do not reply to this email as it is system-generated. For further queries, contact us at <a href='mailto:info@appointmentApp.app'>info@appointmentApp.app</a>.<br><br>" . "Yours sincerely,<br><br>" . "Team Appointment App.";

            $this->email->message($message);

            if ($this->email->send()) {
                $mail_success = array(
                    "status" => true,
                    "message" => "Email sent successfully",
                    "data" => (object) array()
                );
                $this->response($mail_success, REST_Controller::HTTP_OK);
            } else {
                $failure = array(
                    'status' => false,
                    'message' => 'Failed to send email. Please try again.',
                    'data' => (object) array()
                );
                $this->response($failure, REST_Controller::HTTP_INTERNAL_SERVER_ERROR);
            }
        } else {
            $failure = array(
                'status' => false,
                'message' => 'Invalid email.',
                'data' => (object) array()
            );
            $this->response($failure, REST_Controller::HTTP_BAD_REQUEST);
        }
    }

    public function check_mail_code_post()
    {
        $data = json_decode(trim(file_get_contents('php://input')), true);

        $code = isset($data['code']) ? $data['code'] : '';
        $email = isset($data['email']) ? $data['email'] : '';

        // Validate required fields
        if (empty($code) || empty($email)) {
            $failure = array(
                'status' => false,
                'message' => 'Email and code are required.',
                'data' => (object) array()
            );
            $this->response($failure, REST_Controller::HTTP_BAD_REQUEST);
        }

        $q = $this->db->select('*')->from('user')->where('email', $email)->get()->row();

        if ($q && isset($q->f_pass_mailcode)) {
            $code_in_database = $q->f_pass_mailcode;

            if ($code_in_database == $code) {
                $success = array(
                    'status' => true,
                    'message' => 'Successful.',
                    'data' => (object) array()
                );
                $this->response($success, REST_Controller::HTTP_OK);
            } else {
                $failure = array(
                    'status' => false,
                    'message' => 'Invalid code.',
                    'data' => (object) array()
                );
                $this->response($failure, REST_Controller::HTTP_BAD_REQUEST);
            }
        } else {
            $failure = array(
                'status' => false,
                'message' => 'Invalid email.',
                'data' => (object) array()
            );
            $this->response($failure, REST_Controller::HTTP_BAD_REQUEST);
        }
    }



    public function reset_password_post()
    {
        $this->load->library('form_validation');

        $this->form_validation->set_rules('email', 'Email', 'required|valid_email');
        $this->form_validation->set_rules('new_password', 'New Password', 'required');

        if ($this->form_validation->run() == false) {
            $failure = array(
                'status' => false,
                'message' => validation_errors(),
                'data' => (object) array()
            );
            $this->response($failure, REST_Controller::HTTP_BAD_REQUEST);
        }

        $email = $this->input->post('email');
        $password = sha1($this->input->post('new_password'));

        $password_data['password'] = $password;
        $this->load->model('MyModel');
        $q = $this->MyModel->update_password($email, $password_data);

        if ($q == true) {
            $success = array(
                'status' => true,
                'message' => 'Password updated Successfully.',
                'data' => (object) array()
            );
            $this->response($success, REST_Controller::HTTP_OK);
        } else {
            $failure = array(
                'status' => false,
                'message' => 'Error occurred.',
                'data' => (object) array()
            );
            $this->response($failure, REST_Controller::HTTP_BAD_REQUEST);
        }
    }

    /**
     * This is a PHP function that retrieves a list of stores and returns it as a JSON response, with
     * error handling for invalid HTTP methods and missing authentication headers.
     */
    public function stores_get()
    {

        $method = $this->input->method();

        if ($method != 'get') {
            $this->response(array('status' => false, 'message' => 'Method not GET'), REST_Controller::HTTP_BAD_REQUEST);
        } else {

            $check_auth_client = $this->MyModel->check_auth_client_login();


            if ($check_auth_client == true) {


                $query = $this->MyModel->get_store();

                $success = array(
                    'status' => true,
                    'message' => "Success",
                    'data' => array(
                        'stores' => $query,
                    )
                );
                $this->response($success, REST_Controller::HTTP_OK);



            } else {
                $failuer = array(
                    'status' => false,
                    'message' => 'Missing Request Header'
                );
                $this->response($failuer, REST_Controller::HTTP_BAD_REQUEST);
            }
        }
    }
    /**
     * This PHP function retrieves data for a store and its employees based on a given store ID using a GET
     * request.
     */
    public function store_with_their_employee_get()
    {
        $method = $this->input->method();

        if ($method != 'get') {
            $this->response(array('status' => false, 'message' => 'Method not GET'), REST_Controller::HTTP_BAD_REQUEST);
        } else {
            $check_auth_client = $this->MyModel->check_auth_client_login();

            if ($check_auth_client == true) {
                // Read the raw input data
                $rawData = file_get_contents('php://input');
                $requestData = json_decode($rawData, true); // Decode the JSON data

                if (!empty($requestData['store_id'])) {
                    $id = $requestData['store_id'];

                    $query = $this->MyModel->get_store_employee($id);

                    if (!empty($query)) {
                        $success = array(
                            'status' => true,
                            'message' => "Successfully load store and employees data",
                            'data' => array(
                                'store_and_their_employees' => $query,
                            )
                        );
                        $this->response($success, REST_Controller::HTTP_OK);
                    } else {
                        $failure = array(
                            'status' => false,
                            'message' => 'No store found'
                        );
                        $this->response($failure, REST_Controller::HTTP_NOT_FOUND);
                    }
                } else {
                    $failure = array(
                        'status' => false,
                        'message' => 'Missing store_id in the request data'
                    );
                    $this->response($failure, REST_Controller::HTTP_BAD_REQUEST);
                }
            } else {
                $failure = array(
                    'status' => false,
                    'message' => 'Missing Request Header'
                );
                $this->response($failure, REST_Controller::HTTP_BAD_REQUEST);
            }
        }
    }




    public function employee_profile_post()
    {
        $this->load->model('MyModel');

        $method = $this->input->method();

        if ($method != 'post') {
            $this->response(array('status' => false, 'message' => 'Method not POST'), REST_Controller::HTTP_BAD_REQUEST);
        } else {
            $rawData = file_get_contents('php://input');
            $postData = json_decode($rawData, true);

            if ($postData === null) {
                $this->response(array('status' => false, 'message' => 'Invalid JSON data'), REST_Controller::HTTP_BAD_REQUEST);
                return;
            }

            $check_auth_client = $this->MyModel->check_auth_client_login();

            if ($check_auth_client == true) {
                $employee_id = $postData['employee_id'];
                $date = $postData['date'];
                $query = $this->MyModel->employee_detail($employee_id, $date);

                $sqlArray = $this->MyModel->booked_time_slots($employee_id, $date);
                if ($query != null) {
                    $success = array(
                        'status' => true,
                        'message' => "Success",
                        'data' => array(
                            'employee_detail' => array(
                                'name' => $query['name'],
                                'email' => $query['email'],
                                'phone' => $query['phone'],
                                'image' => base_url() . 'assets/img/' . $query['image'],
                                'date' => $date,
                                'start_time' => $query['start_time'],
                                'end_time' => $query['end_time'],
                                'time_gap' => $query['time_gap'],
                                'status' => $query['status'],
                                'booked_time_slots' => array(
                                    'time' => $sqlArray,
                                )
                            )
                        )
                    );
                    $this->response($success, REST_Controller::HTTP_OK);
                } else {
                    $error = array(
                        'status' => false,
                        'message' => 'Employee Record not found for the given date.',
                        'data' => (object) array(),
                    );
                    $this->response($error, REST_Controller::HTTP_BAD_REQUEST);
                }
            } else {
                $failure = array(
                    'status' => false,
                    'message' => 'Missing Request Header'
                );
                $this->response($failure, REST_Controller::HTTP_BAD_REQUEST);
            }
        }
    }

    public function user_profile_get()
    {
        $method = $this->input->method();

        if ($method != 'get') {
            $this->response(array('status' => false, 'message' => 'Method not GET'), REST_Controller::HTTP_BAD_REQUEST);
        } else {
            $rawData = $this->input->raw_input_stream;
            $postData = json_decode($rawData, true);

            if ($postData === null) {
                $this->response(array('status' => false, 'message' => 'Invalid JSON data'), REST_Controller::HTTP_BAD_REQUEST);
                return;
            }

            $check_auth_client = $this->MyModel->check_auth_client_login();

            if ($check_auth_client == true) {
                $id = $postData['id'];

                $query = $this->MyModel->show_user_profile($id);

                if ($query == true) {
                    $success = array(
                        'status' => true,
                        'message' => "Successfully load Profile data.",
                        'data' => array(
                            'name' => $query['name'],
                            'email' => $query['email'],
                            'phone' => $query['phone_number'],
                            'image' => base_url() . 'assets/img/' . $query['image'],
                        )
                    );
                    $this->response($success, REST_Controller::HTTP_OK);
                } else {
                    $error = array(
                        'status' => false,
                        'message' => "Data not found."
                    );
                    $this->response($error, REST_Controller::HTTP_BAD_REQUEST);
                }
            } else {
                $failure = array(
                    'status' => false,
                    'message' => 'Missing Request Header'
                );
                $this->response($failure, REST_Controller::HTTP_BAD_REQUEST);
            }
        }
    }


    // Update user profile by admin.

    public function update_user_profile_put()
    {
        $this->load->model('MyModel');

        $method = $this->input->method();

        if ($method != 'put') {
            $this->response(array('status' => false, 'message' => 'Method not PUT'), REST_Controller::HTTP_BAD_REQUEST);
        } else {
            $rawData = file_get_contents('php://input');
            $postData = json_decode($rawData, true);

            if ($postData === null) {
                $this->response(array('status' => false, 'message' => 'Invalid JSON data'), REST_Controller::HTTP_BAD_REQUEST);
                return;
            }

            $check_auth_client = $this->MyModel->check_auth_client_login();

            if ($check_auth_client == true) {
                $id = $postData['id'];
                $name = $postData['name'];
                $email = $postData['email'];
                $phone = $postData['phone'];

                if (empty($id) || empty($name) || empty($email) || empty($phone)) {
                    $error = array(
                        'status' => false,
                        'message' => 'Missing required fields.'
                    );
                    $this->response($error, REST_Controller::HTTP_BAD_REQUEST);
                    return;
                }

                $formArray['name'] = $name;
                $formArray['email'] = $email;
                $formArray['phone_number'] = $phone;

                $query = $this->MyModel->update_user($id, $formArray);

                if ($query != null) {
                    $sql = $this->MyModel->show_user_profile($id);
                    $success = array(
                        'status' => true,
                        'message' => "Data updated Successfully.",
                        'data' => array(
                            'id' => $sql['id'],
                            'name' => $sql['name'],
                            'email' => $sql['email'],
                            'phone' => $sql['phone_number'],
                            'image' => base_url() . 'assets/img/' . $sql['image'],
                        )
                    );
                    $this->response($success, REST_Controller::HTTP_OK);
                } else {
                    $error = array(
                        'status' => false,
                        'message' => "Data not updated."
                    );
                    $this->response($error, REST_Controller::HTTP_BAD_REQUEST);
                }
            } else {
                $failure = array(
                    'status' => false,
                    'message' => 'Missing Request Header'
                );
                $this->response($failure, REST_Controller::HTTP_BAD_REQUEST);
            }
        }
    }



    public function update_profile_image()
    {
        $this->load->model('MyModel');

        $method = $_SERVER['REQUEST_METHOD'];

        if ($method != 'POST') {

            echo json_encode(array('status' => false, 'message' => 'Method not POST'));
        } else {

            $check_auth_client = $this->MyModel->check_auth_client_login();


            if ($check_auth_client == true) {

                $id = $this->input->post('id');

                $base64Image = $this->input->post('image');

                $this->load->helper('string');
                $image_name = random_string('alnum', 12) . '.jpg';


                $decoded = base64_decode($base64Image);
                file_put_contents('./assets/img/' . $image_name, $decoded);

                $formArray['image'] = $image_name;

                $query = $this->MyModel->update_user($id, $formArray);


                if ($query != null) {
                    $sql = $this->MyModel->show_user_profile($id);
                    $success = array(
                        'status' => true,
                        'message' => "Data updated Successfully.",
                        'data' => array(
                            'id' => $sql['id'],
                            'name' => $sql['name'],
                            'email' => $sql['email'],
                            'phone' => $sql['phone_number'],
                            'image' => base_url() . 'assets/img/' . $sql['image'],
                        )
                    );
                    echo json_encode($success);
                } else {
                    $error = array(
                        'status' => false,
                        'message' => "Image not updated."
                    );
                    echo json_encode($error);
                }

            } else {
                $failuer = array(
                    'status' => false,
                    'message' => 'Missing Request Header'
                );
                echo json_encode($failuer);
            }
        }
    }
   /**
    * This function handles a GET request to submit an order and triggers a Pusher event to notify the
    * store and employee.
    */
    public function order_post()
    {
        $this->load->model('MyModel');


        $method = $this->input->method();

        if ($method != 'post') {
            $this->response(array('status' => false, 'message' => 'Method not POST'), REST_Controller::HTTP_BAD_REQUEST);
        } else {

            $check_auth_client = $this->MyModel->check_auth_client_login();


            if ($check_auth_client == true) {

                $store_id = $this->input->post('store_id');
                $employee_id = $this->input->post('employee_id');
                $date = $this->input->post('date');
                $time = $this->input->post('time');
                $user_id = $this->input->post('user_id');
                $description = $this->input->post('description');


                if ($employee_id == null) {
                    $failure = array(
                        'status' => false,
                        'message' => 'given employee is not available.'
                    );
                    $this->response($failure, REST_Controller::HTTP_BAD_REQUEST);
                } else {
                    $status = 1;

                    $data['store_id'] = $store_id;
                    $data['employee_id'] = $employee_id;
                    $data['user_id'] = $user_id;
                    $data['date'] = $date;
                    $data['time'] = $time;
                    $data['status'] = $status;
                    $data['description'] = $description;

                    $sql = $this->MyModel->order_booking($data);

                    if ($sql != null) {
                        $options = array(
                            'cluster' => 'ap2',
                            'useTLS' => true
                        );
                        $pusher = new Pusher\Pusher(
                            'b4d2618bfd4f5d44747c',
                            '171b0eca2091ec2e080e',
                            '776480',
                            $options
                        );

                        $data['message'] = 'New Order';
                        $pusher->trigger('my-channel-store-' . $store_id, 'my-event', $data);
                        $pusher->trigger('my-channel-emp-' . $employee_id, 'my-event', $data);

                        $success = array(
                            'status' => true,
                            'message' => "order submitted Successfully.",
                            'data' => array(
                                'order_detail' => $sql,
                            )
                        );
                        $this->response($success, REST_Controller::HTTP_OK);
                    } else {
                        $error = array(
                            'status' => false,
                            'message' => "order not submitted."
                        );
                        $this->response($error, REST_Controller::HTTP_BAD_REQUEST);

                    }
                }




            } else {
                $failuer = array(
                    'status' => false,
                    'message' => 'Missing Request Header'
                );
                $this->response($failuer, REST_Controller::HTTP_BAD_REQUEST);
            }
        }
    }
    /**
     * This is a PHP function that retrieves appointments based on the user ID and appointment detail
     * (today, previous, or upcoming) and returns the results in a JSON format.
     */
    public function appointments_post()
    {
        $this->load->model('MyModel');

        $method = $this->input->method();

        if ($method != 'post') {
            $this->response(array('status' => false, 'message' => 'Method not POST'), REST_Controller::HTTP_BAD_REQUEST);
        } else {
            $check_auth_client = $this->MyModel->check_auth_client_login();

            if ($check_auth_client == true) {
                $data = json_decode(file_get_contents('php://input'), true);
                $user_id = $data['user_id'];
                $day = $data['appointment_detail'];

                $date = date('Y-m-d');

                if ($day == 'today') {
                    $query = $this->MyModel->today_appointments($user_id, $date);

                    if ($query != null) {
                        $success = array(
                            'status' => true,
                            'message' => "Record loaded Successfully.",
                            'data' => array(
                                'result' => $query,
                            )
                        );
                        $this->response($success, REST_Controller::HTTP_OK);


                    } else {
                        $failure = array(
                            'status' => false,
                            'message' => 'No record found.',
                            'data' => (object) array()
                        );
                        $this->response($failure, REST_Controller::HTTP_BAD_REQUEST);
                    }
                } elseif ($day == 'previous') {
                    $query = $this->MyModel->previous_appointments($user_id);

                    if ($query != null) {
                        $success = array(
                            'status' => true,
                            'message' => "Record loaded Successfully.",
                            'data' => array(
                                'result' => $query,
                            )
                        );
                        $this->response($success, REST_Controller::HTTP_OK);
                    } else {
                        $failure = array(
                            'status' => false,
                            'message' => 'No record found.',
                            'data' => (object) array()
                        );
                        $this->response($failure, REST_Controller::HTTP_BAD_REQUEST);
                    }
                } elseif ($day == 'upcoming') {
                    $query = $this->MyModel->upcomming_appointments($user_id);

                    if ($query != null) {
                        $success = array(
                            'status' => true,
                            'message' => "Record loaded Successfully.",
                            'data' => array(
                                'result' => $query,
                            )
                        );
                        $this->response($success, REST_Controller::HTTP_OK);
                    } else {
                        $failure = array(
                            'status' => false,
                            'message' => 'No record found.',
                            'data' => (object) array()
                        );
                        $this->response($failure, REST_Controller::HTTP_BAD_REQUEST);
                    }
                }
            } else {
                $failure = array(
                    'status' => false,
                    'message' => 'Missing Request Header'
                );
                $this->response($failure, REST_Controller::HTTP_BAD_REQUEST);
            }
        }
    }

    public function help()
    {

        $method = $_SERVER['REQUEST_METHOD'];

        if ($method != 'POST') {

            echo json_encode(array('status' => false, 'message' => 'Method not POST'));
        } else {

            $check_auth_client = $this->MyModel->check_auth_client_login();


            if ($check_auth_client == true) {

                $email = $this->input->post('email');
                $description = $this->input->post('description');

                $this->load->library('email');

                $html = "halo";

                $config = array();

                $config['protocol'] = 'SMTP';

                $config['smtp_host'] = 'megaxtudio.com';

                $config['smtp_crypto'] = 'ssl';

                $config['smtp_port'] = '587';

                $config['smtp_timeout'] = '7';

                $config['smtp_user'] = 'info@megaxtudio.com';

                $config['smtp_pass'] = 'info@Pakistan123';

                $config['charset'] = 'utf-8';

                $config['newline'] = "\r\n";

                $config['mailtype'] = 'html'; // or html

                $config['validation'] = true; // bool whether to validate email or not
                $this->email->initialize($config);

                $this->email->from('info@megaxtudio.com', 'Appointment App Help.');



                $this->email->to('media@megaxtudio.com');

                $this->email->subject('please help me in the issue cited aabove.');



                $message = $email . '/' . $description;

                $this->email->message($message);
                // $this->email->send();

                if ($this->email->send()) {
                    $mail_success = array(
                        "status" => true,
                        "message" => "Email sent successfully",
                        "data" => (object) array()
                    );
                    echo json_encode($mail_success);
                } else {
                    show_error($this->email->print_debugger());
                }


            } else {
                $failuer = array(
                    'status' => false,
                    'message' => 'Missing Request Header'
                );
                echo json_encode($failuer);
            }
        }
    }
}

?>